/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.actionControllers;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.configurations.processor.IConfigurationProcessor;
import com.aptana.configurations.processor.IConfigurationProcessorListener;
import com.aptana.core.util.EclipseUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.dispatch.BrowserNotifier;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import com.aptana.portal.ui.dispatch.actionControllers.Messages;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsActionController
extends AbstractActionController {
    @ControllerAction
    public Object openPluginsDialog(final Object attributes) {
        final IConfigurationProcessor processor = this.getProcessor();
        UIJob installationJob = new UIJob(Messages.PluginsActionController_installNewSoftware){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                processor.addConfigurationProcessorListener((IConfigurationProcessorListener)PluginsActionController.this);
                final ConfigurationStatus statusResult = processor.configure(monitor, attributes);
                processor.removeConfigurationProcessorListener((IConfigurationProcessorListener)PluginsActionController.this);
                UIJob sendOkJob = new UIJob("Send OK Job"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        statusResult.setStatus("ok");
                        String jsonStatus = JSON.toString((Object)statusResult);
                        BrowserNotifier.getInstance().notifyBrowserInUIThread(Collections.EMPTY_LIST, "plugins", "changed", jsonStatus);
                        return Status.OK_STATUS;
                    }
                };
                EclipseUtil.setSystemForJob((Job)sendOkJob);
                sendOkJob.schedule();
                return Status.OK_STATUS;
            }
        };
        installationJob.schedule();
        return IBrowserNotificationConstants.JSON_OK;
    }

    @ControllerAction
    public Object getInstalledPlugins() {
        IConfigurationProcessor processor = this.getProcessor();
        String processorResult = JSON.toString((Object)processor.getStatus(null, null, false));
        return BrowserNotifier.toJSONNotification("event", "response", processorResult);
    }

    @ControllerAction
    public Object computeInstalledPlugins(final Object lookup) {
        final IConfigurationProcessor processor = this.getProcessor();
        Job computationJob = new Job(Messages.PluginsActionController_computingInstalledPlugins){

            protected IStatus run(IProgressMonitor monitor) {
                processor.addConfigurationProcessorListener((IConfigurationProcessorListener)PluginsActionController.this);
                processor.getStatus(monitor, lookup, true);
                processor.removeConfigurationProcessorListener((IConfigurationProcessorListener)PluginsActionController.this);
                return Status.OK_STATUS;
            }
        };
        computationJob.schedule();
        return IBrowserNotificationConstants.JSON_OK;
    }

    @ControllerAction
    public Object synchronousComputeInstalledPlugins(Object lookup) {
        IConfigurationProcessor processor = this.getProcessor();
        ConfigurationStatus status = processor.getStatus((IProgressMonitor)new NullProgressMonitor(), lookup, true);
        String jsonStatus = JSON.toString((Object)status);
        return jsonStatus;
    }

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
        if (attributesChanged != null && attributesChanged.contains("status")) {
            String jsonStatus = JSON.toString((Object)status);
            BrowserNotifier.getInstance().notifyBrowserInUIThread(Collections.EMPTY_LIST, "plugins", "changed", jsonStatus);
        }
    }
}

